/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskCFSIntegrity;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCFSIntegrity
extends Task {
    protected String m_fileSystem;

    public TaskCFSIntegrity(String[] nodeList, String fileSystem) {
        this(nodeList, fileSystem, null, 1);
    }

    public TaskCFSIntegrity(String[] nodeList, String fileSystem, MultiTaskHandler multiTaskHandler) {
        this(nodeList, fileSystem, multiTaskHandler, 1);
    }

    public TaskCFSIntegrity(String[] nodeList, String fileSystem, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.m_fileSystem = fileSystem;
    }

    public void setFileSystem(String fileSystem) {
        this.m_fileSystem = fileSystem;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing CFS Integrity verification task... ");
        sTaskCFSIntegrity sTask = new sTaskCFSIntegrity(this);
        boolean status = sTask.performCheck();
        return status;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4422", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4473", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    FileSystem: " + this.m_fileSystem);
        return sb.toString();
    }
}

